#include <windows.h>
#include <stdio.h>
#include "extern.h"



BOOL clip_error, clip_error2;
UINT8 dpcm_clip[20];
int dpcm_count;



/*
16-bit audio

Spectrogram says 4-points are damaged when peak overflow occurs!!!
- (a) - 1 - 2 - 3 - 4 - (b)
- Appears as burst of 'energy' on graph
*/



#define EDIT5(a,b,c,d,e,f) \
	{ \
		Reset8(a); \
		\
		buf[lcv-4] = Index8(b); \
		buf[lcv-3] = Index8(c); \
		buf[lcv-2] = Index8(d); \
		buf[lcv-1] = Index8(e); \
		buf[lcv-0] = Index8(f); \
		\
		if( pcm[lcv-0] != ( pcm[lcv-6] + Lookup8( buf[lcv-5] ) + Lookup8( buf[lcv-4] ) + Lookup8( buf[lcv-3] ) + Lookup8( buf[lcv-2] ) + Lookup8( buf[lcv-1] ) + Lookup8( buf[lcv-0] ) ) ) \
			clip_error2 = TRUE; \
		\
		dpcm_count = 0; \
		clip_error = FALSE; \
	}



#define EDIT4(a,b,c,d,e) \
	{ \
		Reset8(a); \
		\
		buf[lcv-3] = Index8(b); \
		buf[lcv-2] = Index8(c); \
		buf[lcv-1] = Index8(d); \
		buf[lcv-0] = Index8(e); \
		\
		if( pcm[lcv-0] != ( pcm[lcv-5] + Lookup8( buf[lcv-4] ) + Lookup8( buf[lcv-3] ) + Lookup8( buf[lcv-2] ) + Lookup8( buf[lcv-1] ) + Lookup8( buf[lcv-0] ) ) ) \
			clip_error2 = TRUE; \
		\
		dpcm_count = 0; \
		clip_error = FALSE; \
	}



// dpcm = (0) - 1 - 2 - 3 - 4 - (5)
#define CHECK5(b) \
	( dpcm_clip[1] == b )





#define CHECK2(b,c) \
	( dpcm_clip[1] == b && dpcm_clip[2] == c )


#define CHECK2_RANGE(b,c1,c2) \
	( dpcm_clip[1] == b && dpcm_clip[2] >= c1 && dpcm_clip[2] <= c2 )





void Clip16_7F__00_78( int lcv )
{
	INT32 start, max;


	// 7A - 7F - 78 - xx
	// - [6C00, 7000 = +400]
	if( dpcm_clip[0] == 0x7A )
	{
		start = 0x6C00;
		max = 0x7000;
	}


	// 7B - 7F - 78 - xx
	// - [6800, 7000 = +800]
	else if( dpcm_clip[0] == 0x7B )
	{
		start = 0x6800;
		max = 0x7000;
	}


	// 7C - 7F - 78 - xx
	// - [6400, 7000 = +C00]
	else if( dpcm_clip[0] == 0x7C )
	{
		start = 0x6C00;
		max = 0x7000;
	}


	// 7D - 7F - 78 - xx
	// - [6000, 7000 = +1000]
	else if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - 78 - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 78 - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 72 - xx


	QG4  @0000E0C.001
	- 71 @ [80B0, C0B8, C9B8, D1B8]  [+3000, +4000, +0900, +0800]
	*/



	// [7000, 3000, F000, D100]  [+yyyy, -4000, -4000]
	// [5000, 5100, 1100, D100, +xxxx]
	if( dpcm_clip[0] == 0x7E && dpcm_clip[2] == 0x72 && dpcm_clip[3] == 0x71 )
	{
		max = start + 0x900;


		EDIT4( start,   max, max - 0x800, max - 0x4000 - 0x800,   (INT16) 0xD000 + 0x100 )
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7F - 7F - 78 - xx


	QG4  @0001368.001
	- 7F @ [8138, C138, D038, 1038]  [+4000, +4000, +0F00, +4000]
	*/



	// 7E
	// - [7000, 3000, F000, +xxxx]  [+yyyy, -4000, -4000]

	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[2] ),
					 max + Lookup8( dpcm_clip[2] ) - 0x4000,
					 max + Lookup8( dpcm_clip[2] ) - 0x8000 )


	// 7F
	// - [7000, 4000, 0000, +xxxx]  [+yyyy, -3000, -4000]

	else if( dpcm_clip[3] == 0x7F )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[2] ),
					 max + Lookup8( dpcm_clip[2] ) - 0x3000,
					 max + Lookup8( dpcm_clip[2] ) - 0x7000 )
}



void Clip16_7F_7A( int lcv )
{
	INT32 start, max;


	// 7D - 7F - 7A - xx
	// - [6000, 5C00 = -400]
	//if( dpcm_clip[0] == 0x7D )
		//start = 0x6000;
	if(0) {}


	// 7E - 7F - 7A - xx
	// - [5000, 5C00 = +C00]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 7A - xx
	// - [4000, 5C00 = +1C00]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;

		
		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7A - xx


	QG4  @0001072.001
	- 7C @ [8058, C058, D458, F058]  [+4000, +4000, +1400, +1C00]
	*/



	// [-1000, -3000, -4000 = -8000]
	if( dpcm_clip[3] == 0x7C )
		EDIT4( start,   max, max - 0x1000, max - 0x4000,   (INT16) 0xF000 )
}



void Clip16_7F_7C( int lcv )
{
	INT32 start, max;


	// 7D - 7F - 7C - xx
	// - [6000, 5C00 = -400]
	//if( dpcm_clip[0] == 0x7D )
		//start = 0x6000;
	if(0) {}


	// 7E - 7F - 7C - xx
	// - [5000, 5C00 = +C00]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 7C - xx
	// - [4000, 5C00 = +1C00]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;

		
		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7C - xx


	PQ4  @000108D.001  (+++)
	- 76 @ [8170, C170, DD70, EA70]  [+3000, +4000, +1C00, +0D00]


	[8000, C000, DC00, E900 - 8000 + 2400]
	*/



	// 00-78  (0000 - 0FF0)
	// - [5C00, 1C00, DC00, +xxxx]  [+yyyy, -4000, -4000]

	if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x78 )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x4000,
					 max + Lookup8( dpcm_clip[3] ) - 0x8000 )
}



void Clip16_7F_7D( int lcv )
{
	INT32 start, max;


	// 7D - 7F - 7D - xx
	// - [6000, 7000 = +1000]
	if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - 7D - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 7D - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7D - xx


	QG4  @00015C6.001
	- 7D @ [8040, C040, E040, 0040]  [+3000, +4000, +2000, +2000]


	PQ4  @00002E8.001  (+++)
	- 7F @ [80E8, C0E8, E0E8, 20E8]  [+3000, +4000, +2000, +4000]
	*/



	// [-1000, -2000, -4000 = -7000]
	if( dpcm_clip[3] == 0x7D )
		EDIT4( start,   max, max - 0x1000, max - 0x3000,   0x0000 )


	// [-800, -1800, -4000 = -6000]
	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max, max - 0x800, max - 0x2000,   0x1000 )


	// [-800, -1800, -3000 = -5000]
	else if( dpcm_clip[3] == 0x7F )
		EDIT4( start,   max, max - 0x800, max - 0x2000,   0x2000 )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7D - xx


	LL6  @0000267.001
	- FE @ [80A8, C0A8, E0A8, B0A8]  [+3000, +4000, +2000, -3000]

	
	QG4  @0000540.001
	- FF @ [80E8, C0E8, E0E8, A0E8]  [+3000, +4000, +2000, -4000]
	*/



	// [-4000, -4000, -4000 = -C000]
	else if( dpcm_clip[3] == 0xFE )
		EDIT4( start,   max, max - 0x4000, max - 0x8000,   (INT16) 0xB000 )


	else if( dpcm_clip[3] == 0xFF )
	{
		// [-4000, -4000, -4000 = -D000]
		if( max == 0x7000 && start < 0x6000 )
		{
			max -= 0x1000;


			EDIT4( start,   max, max - 0x4000, max - 0x8000,   (INT16) 0xA000 )
		}
	}
}



void Clip16_7F_7E( int lcv )
{
	INT32 start, max;


	// 03 - 7F - 7E - xx
	if( dpcm_clip[0] == 0x03 )
	{
		start = 0x7FE0;
		max = 0x7FE0 - 0x50;
	}


	// 75 - 7F - 7E - xx
	else if( dpcm_clip[0] == 0x75 )
	{
		start = 0x7400;
		max = 0x7F00;
	}


	// 7D - 7F - 7E - xx
	// - [6000, 7000 = +1000]
	else if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - 7E - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 7E - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;

		
		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7F - 7F - 7E - xx


	PQ4  @0001716.001  (+++)
	- 1C @ [8028, C028, F028, F1D8]  [+4000, +4000, +3000, +01B0]


	PQ4  @0001B11.001  (+++)
	- 72 @ [80F0, C0F0, F0F0, F9F0]  [+4000, +4000, +3000, +0900]
	*/


	/*
	03 - 7F - 7E


	QG4  @0000421.001
	- 53 @ [8000, C000, F000, F390]  [+0020, +4000, +3000, +0390]
	*/


	/*
	75 - 7F - 7E


	QG4  @0000421.001
	- F4 @ [8028, C028, F028, E528]  [+0C00, +4000, +3000, -0B00]
	*/



	// [-C70, -4000, -4000]
	if( dpcm_clip[0] == 0x03 && dpcm_clip[3] == 0x53 )
		EDIT4( start,   max, max - 0xC00, max - 0x4C00,   max - 0x8C00 )



	// 00-78  (0000 - 0F00)
	// - [7000, 3000, F000, +xxxx]  [+yyyy, -4000, -4000]

	else if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x78 )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x4000,
					 max + Lookup8( dpcm_clip[3] ) - 0x8000 )


	// ##################################################
	// ##################################################
	// ##################################################
							 
	/*
	7E - 7F - 7E - xx


	PQ4  @0002843.001  (+++)
	- 79 @ [8008, C008, F008, 0008]  [+3000, +4000, +3000, +1000]


	QG4  @0000E0D.001
	- 7A @ [8040, C040, F040, 0440]  [+3000, +4000, +3000, +1400]
	*/



	// [-1000, -2000, -4000 = -7000]
	else if( dpcm_clip[3] == 0x79 )
		EDIT4( start,   max, max - 0x1000, max - 0x3000,   0x0000 )


	// [-C00, -2000, -4000 = -6C00]
	else if( dpcm_clip[3] == 0x7A )
		EDIT4( start,   max, max - 0xC00, max - 0x2C00,   0x0400 )


	// [-800, -2000, -4000 = -6800]
	else if( dpcm_clip[3] == 0x7B )
		EDIT4( start,   max, max - 0x800, max - 0x2800,   0x0800 )


	// [-800, -1C00, -4000 = -6400]
	else if( dpcm_clip[3] == 0x7C )
		EDIT4( start,   max, max - 0x800, max - 0x2400,   0x0C00 )


	// [-800, -1800, -4000 = -6000]
	else if( dpcm_clip[3] == 0x7D )
		EDIT4( start,   max, max - 0x800, max - 0x2000,   0x1000 )


	// [-800, -1800, -3000 = -5000]
	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max, max - 0x800, max - 0x2000,   0x2000 )


	// [-400, -1C00, -2000 = -4000]
	else if( dpcm_clip[3] == 0x7F )
		EDIT4( start,   max, max - 0x400, max - 0x2000,   0x3000 )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	75 - 7F - 7E - xx


	QG4  @0000421.001
	- F4 @ [8028, C028, F028, E528]  [+0C00, +4000, +3000, -0B00]
	*/


	/*
	7E - 7F - 7E - xx


	PQ4  @0002875.001  (+++)
	- F4 @ [8010, C010, F010, E510]  [+3000, +4000, +3000, -0B00]
	*/


	/*
	7F - 7F - 7E - xx


	PQ4  @0001700.001  (+++)
	- FC @ [81B0, C1B0, F1B0, D5B0]  [+4000, +4000, +3000, -1C00]
	*/



	// [7400, 7D00, 3F00, FF00, E500]
	else if( dpcm_clip[0] == 0x75 && dpcm_clip[3] == 0xF4 )
	{
		// -1800
		dpcm_clip[3] = 0xFB;
		max = 0x7D00;


		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x4000,
					 max + Lookup8( dpcm_clip[3] ) - 0x8000 )
	}

					 
					 
	// 80-FF  (0000 - 4000)
	// - [7000, 3000, F000, -xxxx]  [-yyyy, -4000, -4000]

	else if( dpcm_clip[3] >= 0x80 && dpcm_clip[3] <= 0xFF )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x4000,
					 max + Lookup8( dpcm_clip[3] ) - 0x8000 )
}



void Clip16_7F_7F( int lcv )
{
	INT32 start, max;


	// 23 - 7F - 7F - xx
	// - [6000, 7000 = +1000]

	if( dpcm_clip[0] <= 0x79 )
	{
		start = pcm[lcv-4];
		max = 0x10000;
	}


	// 7A - 7F - 7F - xx
	// - [6C00, 7000 = +400]
	else if( dpcm_clip[0] == 0x7A )
	{
		start = 0x6C00;
		max = 0x7000;
	}


	// 7B - 7F - 7F - xx
	// - [6800, 7000 = +800]
	else if( dpcm_clip[0] == 0x7B )
	{
		start = 0x6800;
		max = 0x7000;
	}


	// 7C - 7F - 7F - xx
	// - [6400, 7000 = +C00]
	else if( dpcm_clip[0] == 0x7C )
	{
		start = 0x6400;
		max = 0x7000;
	}


	// 7D - 7F - 7F - xx
	// - [6000, 7000 = +1000]
	else if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - 7F - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - 7F - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;

		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7F - xx


	PQ4  @0000190.001  (+++)
	- 07 @ [8038, C038, 0038, 0098]  [+3000, +4000, +4000, +0060]


	PQ4  @0002369.001  (+++)
	- 17 @ [8190, C190, 0190, 02F0]  [+3000, +4000, +4000, +0160]


	PQ4  @0001BC7.001  (+++)
	- 2D @ [8208, C208, 0208, 0468]  [+3000, +4000, +4000, +0260]


	PQ4  @0000518.001  (+++)
	- 6A @ [8098, C098, 0098, 06D8]  [+3000, +4000, +4000, +0640]


	PQ4  @00013D5.001  (+++)
	- 76 @ [8070, C070, 0070, 0D70]  [+3000, +4000, +4000, +0D00]
	*/



	/*
	7F - 7F - 7F - xx


	PQ4  @0000630.001  (+++)
	- 18 @ [8228, C228, 0228, 0398]  [+4000, +4000, +4000, +0170]


	PQ4  @000284F.001  (+++)
	- 67 @ [80C0, C0C0, 00C0, 0640]  [+4000, +4000, +4000, +0580]


	PQ4  @0000AA0.001  (+++)
	- 70 @ [8360, C360, 0360, 0B20]  [+4000, +4000, +4000, +07C0]


	PQ4  @0001DCC.001  (+++)
	- 71 @ [8150, C150, 0150, 0950]  [+4000, +4000, +4000, +0800]


	PQ4  @0001B13.001  (+++)
	- 73 @ [8048, C048, 0048, 0A48]  [+4000, +4000, +4000, +0A00]
	*/



	// 00-78  (0000 - 0F00)
	// - [7000, 4000, 0000, +xxxx]  [+yyyy, -3000, -4000]

	if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x78 )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x3000,
					 max + Lookup8( dpcm_clip[3] ) - 0x7000 )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - 7F - xx


	PQ4  @000290C.001  (+++)
	- 79 @ [8010, C010, 0010, 1010]  [+3000, +4000, +4000, +1000]


	PQ4  @000149E.001  (+++)
	- 7B @ [8060, C060, 0060, 1860]  [+3000, +4000, +4000, +1800]


	PQ4  @00021AF.001  (+++)
	- 7C @ [8180, C180, 0180, 1D80]  [+3000, +4000, +4000, +1C00]


	PQ4  @00005DC.001  (+++)
	- 7D @ [80F0, C0F0, 00F0, 20F0]  [+3000, +4000, +4000, +2000]


	PQ4  @0000938.001  (+++)
	- 7E @ [8090, C090, 0090, 3090]  [+3000, +4000, +4000, +3000]


	PQ4  @00000B8.001  (+++)
	- 7F @ [8048, C048, 0048, 4048]  [+3000, +4000, +4000, +4000]
	*/



	/*
	7F - 7F - 7F - xx


	PQ4  @0002595.001  (+++)
	- 7A @ [8198, C198, 0198, 1598]  [+4000, +4000, +4000, +1400]


	PQ4  @0000D19.001  (+++)
	- 7D @ [8188, C188, 0188, 2188]  [+4000, +4000, +4000, +2000]


	PQ4  @00024E8.001  (+++)
	- 7E @ [8180, C180, 0180, 3180]  [+4000, +4000, +4000, +3000]


	PQ4  @0001FE2.001  (+++)
	- 7F @ [8118, C118, 0118, 4118]  [+4000, +4000, +4000, +4000]
	*/



	// [-1000, -2000, -3000 = -6000]
	else if( dpcm_clip[3] == 0x79 )
		EDIT4( start,   max, max - 0x1000, max - 0x3000,   0x1000 )


	// [-C00, -2000, -3000 = -5C00]
	else if( dpcm_clip[3] == 0x7A )
		EDIT4( start,   max, max - 0xC00, max - 0x2C00,   0x1400 )


	// [-800, -2000, -3000 = -5800]
	else if( dpcm_clip[3] == 0x7B )
		EDIT4( start,   max, max - 0x800, max - 0x2800,   0x1800 )


	// [-800, -1C00, -3000 = -5400]
	else if( dpcm_clip[3] == 0x7C )
		EDIT4( start,   max, max - 0x800, max - 0x2400,   0x1C00 )


	// [-800, -1800, -3000 = -5000]
	else if( dpcm_clip[3] == 0x7D )
		EDIT4( start,   max, max - 0x800, max - 0x2000,   0x2000 )


	// [-400, -1C00, -2000 = -4000]
	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max, max - 0x400, max - 0x2000,   0x3000 )


	// [-400, -1400, -1800 = -3000]
	else if( dpcm_clip[3] == 0x7F )
	{
		// [7DD8, 7FF0, -3F0 = -3xx0]
		if( dpcm_clip[0] == 0x26 )
		{
			max = start + 0x218;


			EDIT4( start,   max, max - 0x3F0, max - 0x3F0 - 0x1C00,   0x4000 )
		}

		else if( dpcm_clip[0] == 0x3A )
		{
			max = start + 0x2B8;


			EDIT4( start,   max, max - 0x3F0, max - 0x3F0 - 0x1C00,   0x4000 )
		}

		// [-3xx, -1C00, -2000 = -3xx0]
		else if( dpcm_clip[0] <= 0x53 )
		{
			max = 0x7FF0 + ( start & 0x0F );


			EDIT4( start,   max, max - 0x3F0, max - 0x1FF0,   max - 0x3FF0 )
		}

		else
			EDIT4( start,   max, max - 0x400, max - 0x1800,   0x4000 )
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	23 - 7F - 7F - xx


	QG4  @0000421.001
	- F9 @ [8000, C000, 0000, F000]  [+0210, +4000, +4000, -1000]
	*/


	/*
	59 - 7F - 7F - xx


	QG4  @0000421.001
	- AB @ [8000, C000, 0000, FDB0]  [+03C0, +4000, +4000, -0250]
	*/


	/*
	7E - 7F - 7F - xx


	PQ4  @0001C0A.001  (+++)
	- EC @ EDIT4( 0x5110,   0x7110, 0x4110, 0x0110,   (INT16) 0xFA50 )

	
	PQ4  @00004A8.001  (+++)
	- F8 @ EDIT4( 0x5050,   0x7050, 0x4050, 0x0050,   (INT16) 0xF150 )


	PQ4  @0000B51.001  (+++)
	- F9 @ EDIT4( 0x50A0,   0x70A0, 0x40A0, 0x00A0,   (INT16) 0xF0A0 )


	PQ4  @0000320.001  (+++)
	- FA @ [8158, C158, 0158, ED58]  [+3000, +4000, +4000, -1400]


	PQ4  @0000D86.001  (+++)
	- FC @ EDIT4( 0x5110,   0x7110, 0x4110, 0x0110,   (INT16) 0xE510 )


	PQ4  @0000B27.001  (+++)
	- FD @ EDIT4( 0x50C0,   0x70C0, 0x40C0, 0x00C0,   (INT16) 0xE0C0 )


	PQ4  @0002249.001  (+++)
	- FE @ EDIT4( 0x5050,   0x7050, 0x4050, 0x0050,   (INT16) 0xD050 )


	PQ4  @0000771.001  (+++)
	- FF @ EDIT4( 0x5170,   0x7170, 0x4170, 0x0170,   (INT16) 0xC170 )
	*/



	/*
	7F - 7F - 7F - xx


	PQ4  @0000566.001  (+++)
	- F1 @ [8098, C098, 0098, F898]  [+4000, +4000, +4000, -0800]


	PQ4  @0000A90.001  (+++)
	- F6 @ [8130, C130, 0130, F430]  [+4000, +4000, +4000, -0D00]


	PQ4  @000024F.001  (+++)
	- F9 @ [8150, C150, 0150, F150]  [+4000, +4000, +4000, -1000]


	PQ4  @000117C.001  (+++)
	- FA @ EDIT4( 0x4210,   0x7210, 0x4210, 0x0210,   (INT16) 0xEE10 )


	PQ4  @0000FA6.001  (+++)
	- FB @ EDIT4( 0x4060,   0x7060, 0x4060, 0x0060,   (INT16) 0xE860 )


	PQ4  @0000A1A.001  (+++)
	- FD @ EDIT4( 0x4100,   0x7100, 0x4100, 0x0100,   (INT16) 0xE100 )


	PQ4  @0000848.001  (+++)
	- FE @ EDIT4( 0x4150,   0x7150, 0x4150, 0x0150,   (INT16) 0xD150 )


	PQ4  @0000EB9.001  (+++)
	- FF @ EDIT4( 0x4260,   0x7260, 0x4260, 0x0260,   (INT16) 0xC260 )
	*/



	// [7DF0, 7F00, 3F00, FF00, F000]
	else if( dpcm_clip[0] == 0x23 && dpcm_clip[3] == 0xF9 )
	{
		start = 0x7DF0;
		max = 0x7F00;


		EDIT4( start,   max, max - 0xF00, max - 0x4F00,   (INT16) 0xF000 )
	}


	// [7CF0, 7F00, 3F00, F000, -xxxx]
	else if( dpcm_clip[0] == 0x59 && dpcm_clip[3] == 0xAB )
	{
		start = 0x7C40;
		max = 0x7F00;

		// [-150]
		dpcm_clip[3] = 0x96;


		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x4000,
					 max + Lookup8( dpcm_clip[3] ) - 0x8000 )
	}


	// 80-FF  (0000 - 3000)
	// - [7000, 4000, 0000, -xxxx]  [-yyyy, -3000, -4000]

	else if( dpcm_clip[3] >= 0x80 && dpcm_clip[3] <= 0xFE )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) - 0x3000,
					 max + Lookup8( dpcm_clip[3] ) - 0x7000 )


	// FF
	// - [7000, 4000, 0000, C000]  [-3000, -4000, -4000]

	else if( dpcm_clip[3] == 0xFF )
		EDIT4( start,   max, max - 0x3000, max - 0x7000,   (INT16) 0xC000 )
}



void Clip16_7F_E4( int lcv )
{
	INT32 start, max;


	// 7D - 7F - E4 - xx
	// - [6000, 7000 = +1000]
	if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - E4 - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - E4 - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - E4 - xx


	QG4  @0000540.001
	- 72 @ [8190, C190, BCD0, C5D0]  [+3000, +4000, -04C0, +0900]


	[7000, 3000, F000, xxxx]
	[5000, 1000, D000, xxxx]
	*/



	// [-4000, -4000, -4000 = -C000]
	if( dpcm_clip[3] == 0x72 )
	{
		if( dpcm_clip[0] == 0x7E )
		{
			// backup last byte  [-1000]
			if( buf[lcv-4] == 0x7F )
				buf[lcv-4] = 0x7E;


			max = start + Lookup8( dpcm_clip[3] );


			EDIT4( start,   max,
						 max + Lookup8( dpcm_clip[2] ),
						 max + Lookup8( dpcm_clip[2] ) - 0x4000,
						 max + Lookup8( dpcm_clip[2] ) - 0x8000 )
		}
	}
}



void Clip16_7F_FD( int lcv )
{
	INT32 start, max;


	// 7D - 7F - FD - xx
	// - [6000, 7000 = +1000]
	if( dpcm_clip[0] == 0x7D )
	{
		start = 0x6000;
		max = 0x7000;
	}


	// 7E - 7F - FD - xx
	// - [5000, 7000 = +2000]
	else if( dpcm_clip[0] == 0x7E )
	{
		start = 0x5000;
		max = 0x7000;
	}


	// 7F - 7F - FD - xx
	// - [4000, 7000 = +3000]
	else if( dpcm_clip[0] == 0x7F )
	{
		start = 0x4000;
		max = 0x7000;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	7E - 7F - FD - xx


	QG4  @0000421.001
	- 7F @ [81E8, C1E8, A1E8, E1E8]  [+3000, +4000, -2000, +4000]
	*/



	// [-4000, -4000, -4000 = -C000]
	if( dpcm_clip[3] == 0x7D )
		EDIT4( start,   max, max - 0x4000, max - 0x8000,   (INT16) 0xB000 )


	// [-3000, -4000, -4000 = -B000]
	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max, max - 0x3000, max - 0x7000,   (INT16) 0xC000 )


	// [-2000, -4000, -4000 = -A000]
	else if( dpcm_clip[3] == 0x7E )
		EDIT4( start,   max, max - 0x2000, max - 0x6000,   (INT16) 0xD000 )


	// [-2000, -3000, -4000 = -9000]
	else if( dpcm_clip[3] == 0x7F )
		EDIT4( start,   max, max - 0x2000, max - 0x5000,   (INT16) 0xE000 )
}



void Clip16_8C_F1( int lcv )
{
	INT32 start, max;


	if( dpcm_clip[0] <= 0xF8 )
	{
		start = (INT16) 0x5FFF;
		max = (INT16) 0x7FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	if( dpcm_clip[0] == 0x63 && dpcm_clip[3] == 0xF6 )
	{
		start = 0x7BA0;
		max = start + 0x3D0;


		// [7F78, xx, xx, 6A78 = -1500]
		EDIT4( start,   max, max - 0x200, max - 0x600,   0x6A70 )
	}
}



void Clip16_E9_F5( int lcv )
{
	INT32 start, max;


	if( dpcm_clip[0] <= 0xF8 )
	{
		start = (INT16) 0x5FFF;
		max = (INT16) 0x7FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	if( dpcm_clip[0] == 0x18 && dpcm_clip[3] == 0xF5 )
	{
		start = 0x7ED0;
		max = start + 0x70;


		// [7F40, xx, xx, 6240 = -1D00]
		EDIT4( start,   max, max - 0x500, max - 0xD00,   0x6240 )
	}
}



void Clip16_FF__00_78( int lcv )
{
	INT32 start, max;


	// FD - FF - 63 - xx
	// - [9000, 8000 = -1000]
	if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - 63 - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - 63 - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FF - FF - 63 - xx


	PQ4  @00024DF.001  (+++)
	- FE @ [7FE8, 3FE8, 4468, 1468]  [-4000, -4000, +0480, -3000]


	[8000, 4000, 0000, 0480]
	*/


	/*
	FE - FF - 6C - xx


	QG4  @0000348.001
	- F3 @ [7F00, 3F00, 45C0, 3BC0]  [-3000, -4000, +06C0, -0A00]


	[B000, F000, 3000, xxxx]
	*/



	// [+4000, +4000 = +8000]
	if( dpcm_clip[3] == 0xFE )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[2] ),
					 max + Lookup8( dpcm_clip[2] ) + 0x4000,
					 max + Lookup8( dpcm_clip[2] ) + 0x8000 )


	// [+4000, +4000 = +8000]
	else if( dpcm_clip[3] <= 0xF8 )
	{
		// [+1000 --> B000]
		if( dpcm_clip[0] == 0xFE )
		{
			// backup last byte
			if( buf[lcv-4] == 0xFE )
				buf[lcv-4] = 0xFD;



			max = start + Lookup8( dpcm_clip[3] );


			EDIT4( start,   max,
						 max + Lookup8( dpcm_clip[2] ) ,
						 max + Lookup8( dpcm_clip[2] ) + 0x4000,
						 max + Lookup8( dpcm_clip[2] ) + 0x8000 )
		}
	}
}



void Clip16_FF_7E( int lcv )
{
	INT32 start, max;


	// FD - FF - 7E - xx
	// - [9000, 8000 = -1000]
	if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - 7E - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - 7E - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - 7E - xx


	QG4  @0000E00.001
	- FF @ [7EB8, 3EB8, 6EB8, 2EB8]  [-3000, -4000, +3000, -4000]
	*/

	
	
	// [+2000, +4000, +4000 = -A000]
	if( dpcm_clip[3] == 0xFF )
		EDIT4( start,   max, max + 0x2000, max + 0x6000,   0x2000 + 0xFFF )
}



void Clip16_FF_FB( int lcv )
{
	INT32 start, max;


	// FD - FF - FB - xx
	// - [9000, 8000 = -1000]
	if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - FB - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - FB - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FB - xx


	QG4  @0001261.001
	- 7F @ [7F40, 3F40, 2740, 6740]  [-3000, -4000, -1800, +4000]
	*/



	// 7F
	// - [A000, A800, E800, 2800, 6800]

	if( dpcm_clip[3] == 0x7F )
	{
		// normal
		if( dpcm_clip[0] == 0xFE )
		{
			max = (INT16) 0xAFFF - 0x800;


			EDIT4( start,   max, max + 0x4000, max + 0x8000,   max + 0xC000 )
		}
	}
}



void Clip16_FF_FD( int lcv )
{
	INT32 start, max;


	// FD - FF - FD - xx
	// - [9000, 8000 = -1000]
	if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - FD - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - FD - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FD - xx


	QG4  @00007BC.001
	- 0F @ [7FF0, 3FF0, 1FF0, 20D0]  [-3000, -4000, -2000, +00E0]
	*/



	// 00-7F  (0000 - 4000)
	// - [A000, E000, 2000, +xxxx]  [+yyyy, +4000, +4000]

	if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x7F )
	{
		// normal
		if( dpcm_clip[0] == 0xFD )
		{
			max = (INT16) 0xAFFF;


			EDIT4( start,   max,
						 max + Lookup8( dpcm_clip[3] ),
						 max + Lookup8( dpcm_clip[3] ) + 0x4000,
						 max + Lookup8( dpcm_clip[3] ) + 0x8000 )
		}


		else if( dpcm_clip[0] >= 0xFE && dpcm_clip[0] <= 0xFF )
		{
			max = (INT16) 0x9FFF;


			EDIT4( start,   max,
						 max + Lookup8( dpcm_clip[3] ),
						 max + Lookup8( dpcm_clip[3] ) + 0x4000,
						 max + Lookup8( dpcm_clip[3] ) + 0x8000 )
		}
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FD - xx


	QG4  @0000B54.001
	- FE @ [7F80, 3F80, 1F80, EF80]  [-3000, -4000, -2000, -3000]
	*/



	// [+1000, +2000, +4000 = +7000]
	else if( dpcm_clip[3] == 0xFD )
		EDIT4( start,   max, max + 0x1000, max + 0x3000,   (INT16) 0xF000 + 0xFFF )


	// [+800, +1800, +4000 = +6000]
	else if( dpcm_clip[3] == 0xFE )
		EDIT4( start,   max, max + 0x800, max + 0x2000,   (INT16) 0xE000 + 0xFFF )


	// [+800, +1800, +3000 = +5000]
	else if( dpcm_clip[3] == 0xFF )
		EDIT4( start,   max, max + 0x800, max + 0x2000,   (INT16) 0xD000 + 0xFFF )
}



void Clip16_FF_FE( int lcv )
{
	INT32 start, max;


	// FD - FF - FE - xx
	// - [9000, 8000 = -1000]
	if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - FE - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - FE - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	// 00-7F  (0000 - 4000)
	// - [8000, C000, 0000, +xxxx]  [+yyyy, +4000, +4000]

	if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x7F )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) + 0x4000,
					 max + Lookup8( dpcm_clip[3] ) + 0x8000 )


	// ##################################################
	// ##################################################
	// ##################################################

	// 80-F8  (0000 - 0F00)
	// - [8000, C000, 0000, -xxxx]  [-yyyy, +4000, +4000]

	else if( dpcm_clip[3] >= 0x80 && dpcm_clip[3] <= 0xF8 )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) + 0x4000,
					 max + Lookup8( dpcm_clip[3] ) + 0x8000 )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FF - FF - FE - xx


	QG4  @0001AED.001
	- FF @ [7FC8, 3FC8, 0FC8, CFC8]  [-4000, -4000, -3000, -4000]
	*/



	// [+1000, +2000, +4000 = +7000]
	else if( dpcm_clip[3] == 0xF9 )
		EDIT4( start,   max, max + 0x1000, max + 0x3000,   (INT16) 0xF000 + 0xFFF )


	// [+C00, +2000, +4000 = +6C00]
	else if( dpcm_clip[3] == 0xFA )
		EDIT4( start,   max, max + 0xC00, max + 0x2C00,   (INT16) 0xEC00 + 0xFFF )


	// [+800, +2000, +4000 = +6800]
	else if( dpcm_clip[3] == 0xFB )
		EDIT4( start,   max, max + 0x800, max + 0x2800,   (INT16) 0xE800 + 0xFFF )


	// [+800, +1C00, +4000 = +6400]
	else if( dpcm_clip[3] == 0xFC )
		EDIT4( start,   max, max + 0x800, max + 0x2400,   (INT16) 0xE400 + 0xFFF )


	// [+800, +1800, +4000 = +6000]
	else if( dpcm_clip[3] == 0xFD )
		EDIT4( start,   max, max + 0x800, max + 0x2000,   (INT16) 0xE000 + 0xFFF )


	// [+800, +1800, +3000 = +5000]
	else if( dpcm_clip[3] == 0xFE )
		EDIT4( start,   max, max + 0x800, max + 0x2000,   (INT16) 0xD000 + 0xFFF )


	// [+400, +1C00, +2000 = +4000]
	else if( dpcm_clip[3] == 0xFF )
		EDIT4( start,   max, max + 0x400, max + 0x2000,   (INT16) 0xC000 + 0xFFF )
}



void Clip16_FF_FF( int lcv )
{
	INT32 start, max;


	if( dpcm_clip[0] >= 0x80 && dpcm_clip[0] <= 0xF8 )
	{
		start = pcm[lcv-4];
		start += 0xFFF;
		max = (INT16) 0x8FFF;
	}


	// FD - FF - FF - xx
	// - [9000, 8000 = -1000]
	else if( dpcm_clip[0] == 0xFD )
	{
		start = (INT16) 0x9FFF;
		max = (INT16) 0x8FFF;
	}


	// FE - FF - FF - xx
	// - [A000, 8000 = -2000]
	else if( dpcm_clip[0] == 0xFE )
	{
		start = (INT16) 0xAFFF;
		max = (INT16) 0x8FFF;
	}


	// FF - FF - FF - xx
	// - [B000, 8000 = -3000]
	else if( dpcm_clip[0] == 0xFF )
	{
		start = (INT16) 0xBFFF;
		max = (INT16) 0x8FFF;
	}


	else
	{
		start = -0x8000;
		max = 0x10000;


		fix_clip = FALSE;
	}


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FF - xx


	PQ4  @0000697.001  (+++)
	- 74 @ [7EF8, 3EF8, FEF8, 09F8]  [-3000, -4000, -4000, +0B00]


	PQ4  @0001AEE.001  (+++)
	- 79 @ [7FF8, 3FF8, FFF8, 0FF8]  [-3000, -4000, -4000, +1000]


	PQ4  @00022EC.001  (+++)
	- 7F @ [7FE8, 3FE8, FFE8, 3FE8]  [-3000, -4000, -4000, +4000]
	*/



	// 00-7E  (0000 - 3000)
	// - [8000, B000, F000, +xxxx]  [+yyyy, +3000, +4000]

	if( dpcm_clip[3] >= 0x00 && dpcm_clip[3] <= 0x7E )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) + 0x3000,
					 max + Lookup8( dpcm_clip[3] ) + 0x7000 )


	// 7F
	else if( dpcm_clip[3] == 0x7F )
		EDIT4( start,   max, (INT16) 0xBFFF, (INT16) 0xFFFF,   0x3FFF )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FF - xx


	QG4  @00000B0.001
	- D8 @ [7EB0, 3EB0, FEB0, FAF8]  [-3000, -4000, -4000, -03B8]
	*/


	/*
	FF - FF - FF - xx

	
	QG4  @0000054.001
	- F8 @ [7F70, 3F70, FF70, F070]  [-4000, -4000, -4000, -0F00]
	*/



	// 80-F8  (0000 - 0F00)
	// - [8000, B000, F000, -xxxx]  [-yyyy, +3000, +4000]

	else if( dpcm_clip[3] >= 0x80 && dpcm_clip[3] <= 0xF8 )
		EDIT4( start,   max,
					 max + Lookup8( dpcm_clip[3] ),
					 max + Lookup8( dpcm_clip[3] ) + 0x3000,
					 max + Lookup8( dpcm_clip[3] ) + 0x7000 )


	// ##################################################
	// ##################################################
	// ##################################################

	/*
	FE - FF - FF - xx


	PQ4  @000105F.001  (+++)
	- FA @ [7E00, 3E00, FE00, EA00]  [-3000, -4000, -4000, -1400]


	PQ4  @00002AF.001  (+++)
	- FF @ [7E98, 3E98, FE98, BE98]  [-3000, -4000, -4000, -4000]
	*/


	/*
	FF - FF - FF - xx
	
		
	QG4  @0000044.001
	- FD @ [7F30, 3F30, FF30, DF30]  [-4000, -4000, -4000, -2000]

	
	QG4  @0000007.001
	- FF @ [7ED0, 3ED0, FED0, BED0]  [-4000, -4000, -4000, -4000]
	*/



	// [+1000, +2000, +3000 = +6000]
	else if( dpcm_clip[3] == 0xF9 )
		EDIT4( start,   max, max + 0x1000, max + 0x3000,   (INT16) 0xE000 + 0xFFF )


	// [+C00, +2000, +3000 = +5C00]
	else if( dpcm_clip[3] == 0xFA )
		EDIT4( start,   max, max + 0xC00, max + 0x2C00,   (INT16) 0xDC00 + 0xFFF )


	// [+800, +2000, +3000 = +5800]
	else if( dpcm_clip[3] == 0xFB )
		EDIT4( start,   max, max + 0x800, max + 0x2800,   (INT16) 0xD800 + 0xFFF )


	// [+800, +1C00, +3000 = +5400]
	else if( dpcm_clip[3] == 0xFC )
		EDIT4( start,   max, max + 0x800, max + 0x2400,   (INT16) 0xD400 + 0xFFF )


	// [+800, +1800, +3000 = +5000]
	else if( dpcm_clip[3] == 0xFD )
		EDIT4( start,   max, max + 0x800, max + 0x2000,   (INT16) 0xD000 + 0xFFF )


	// [+400, +1C00, +2000 = +4000]
	else if( dpcm_clip[3] == 0xFE )
		EDIT4( start,   max, max + 0x400, max + 0x2000,   (INT16) 0xC000 + 0xFFF )


	// [+400, +1400, +1800 = +3000]
	else if( dpcm_clip[3] == 0xFF )
	{
		if( dpcm_clip[0] == 0x8C )
		{
			max = start + 0x50;

			EDIT4( start,   max, max + 0x700, max + 0x1F00,   max + 0x3F00 )
		}

		else if( dpcm_clip[0] == 0x94 )
		{
			max = start - 0x30;

			EDIT4( start,   max, max + 0x700, max + 0x1F00,   max + 0x3F00 )
		}

		else
			EDIT4( start,   max, max + 0x400, max + 0x1800,   (INT16) 0xB000 + 0xFFF )
	}
}



void Fix_Clip16( int lcv )
{
	if( check_clip == FALSE )
		return;



	// adjust values for curve
	if( overflow == TRUE && dpcm_count == 0 )
	{
		dpcm_count = 0;


		// init table
		dpcm_clip[ dpcm_count ] = buf[ lcv ];
		dpcm_count++;
	}

	else if( dpcm_count >= 1 )
	{
		dpcm_clip[ dpcm_count ] = buf[ lcv ];
		dpcm_count++;
	}



	clip_error = FALSE;
	clip_error2 = FALSE;


	if( dpcm_count == 4 )
	{
		fix_clip = TRUE;
		clip_error = TRUE;


		if(0) {}


		// xx - 7F - [00-78] - xx
		else if( CHECK2_RANGE( 0x7F, 0x00, 0x78 ) )
			Clip16_7F__00_78( lcv );


		// xx - 7F - 7A - xx
		else if( CHECK2( 0x7F, 0x7A ) )
			Clip16_7F_7A( lcv );


		// xx - 7F - 7C - xx
		else if( CHECK2( 0x7F, 0x7C ) )
			Clip16_7F_7C( lcv );


		// xx - 7F - 7D - xx
		else if( CHECK2( 0x7F, 0x7D ) )
			Clip16_7F_7D( lcv );


		// xx - 7F - 7E - xx
		else if( CHECK2( 0x7F, 0x7E ) )
			Clip16_7F_7E( lcv );


		// xx - 7F - 7F - xx
		else if( CHECK2( 0x7F, 0x7F ) )
			Clip16_7F_7F( lcv );


		// xx - 7F - E4 - xx
		else if( CHECK2( 0x7F, 0xE4 ) )
			Clip16_7F_E4( lcv );


		// xx - 7F - FD - xx
		else if( CHECK2( 0x7F, 0xFD ) )
			Clip16_7F_FD( lcv );


		// ###############################################
		// ###############################################
		// ###############################################

		// xx - 8C - F1 - xx
		else if( CHECK2( 0x8C, 0xF1 ) )
			Clip16_8C_F1( lcv );


		// xx - E9 - F5 - xx
		else if( CHECK2( 0xE9, 0xF5 ) )
			Clip16_E9_F5( lcv );


		// xx - FF - [00-78] - xx
		else if( CHECK2_RANGE( 0xFF, 0x00, 0x78 ) )
			Clip16_FF__00_78( lcv );


		// xx - FF - 7E - xx
		else if( CHECK2( 0xFF, 0x7E ) )
			Clip16_FF_7E( lcv );


		// xx - FF - FB - xx
		else if( CHECK2( 0xFF, 0xFB ) )
			Clip16_FF_FB( lcv );


		// xx - FF - FD - xx
		else if( CHECK2( 0xFF, 0xFD ) )
			Clip16_FF_FD( lcv );


		// xx - FF - FE - xx
		else if( CHECK2( 0xFF, 0xFE ) )
			Clip16_FF_FE( lcv );


		// xx - FF - FF - xx
		else if( CHECK2( 0xFF, 0xFF ) )
			Clip16_FF_FF( lcv );
	}


	// unknown - don't adjust
	else if( dpcm_count >= 5 )
		clip_error = TRUE;



	if( clip_error == TRUE )
	{
		fprintf( fp_log, "--- Unknown pattern\n" );


		fix_clip = FALSE;
		error_found++;


		dpcm_count = 0;
	}


	if( clip_error2 == TRUE )
	{
		fprintf( fp_log, "--- Bad curve = %04X\n",
			( pcm[lcv-5] + Lookup8( buf[lcv-4] ) + Lookup8( buf[lcv-3] ) + Lookup8( buf[lcv-2] ) + Lookup8( buf[lcv-1] ) + Lookup8( buf[lcv-0] ) ) & 0xFFFF
		);


		fix_clip = FALSE;
		error_found++;


		dpcm_count = 0;
	}
}



void Fix_Clip16_2( int lcv )
{
	if( check_clip == FALSE )
		return;



	// adjust values for curve
	if( overflow == TRUE && dpcm_count == 0 )
	{
		dpcm_count = 0;


		// init table
		dpcm_clip[ dpcm_count ] = buf[ lcv ];
		dpcm_count++;
	}

	else if( dpcm_count >= 1 )
	{
		dpcm_clip[ dpcm_count ] = buf[ lcv ];
		dpcm_count++;
	}



	clip_error = FALSE;
	clip_error2 = FALSE;


	// 4 points damaged - need 5 for smooth curve (no noise)
	if( dpcm_count == 5 )
	{
		fix_clip = TRUE;
		clip_error = TRUE;


		if(0) {}


		else if( CHECK5( 0x7F ) )
		{}

		//Connect();

		/*
		// xx - 7F - [00-78] - xx
		else if( CHECK2_RANGE( 0x7F, 0x00, 0x78 ) )
			Clip16_7F__00_78( lcv );


		// xx - 7F - 7A - xx
		else if( CHECK2( 0x7F, 0x7A ) )
			Clip16_7F_7A( lcv );


		// xx - 7F - 7C - xx
		else if( CHECK2( 0x7F, 0x7C ) )
			Clip16_7F_7C( lcv );


		// xx - 7F - 7D - xx
		else if( CHECK2( 0x7F, 0x7D ) )
			Clip16_7F_7D( lcv );


		// xx - 7F - 7E - xx
		else if( CHECK2( 0x7F, 0x7E ) )
			Clip16_7F_7E( lcv );


		// xx - 7F - 7F - xx
		else if( CHECK2( 0x7F, 0x7F ) )
			Clip16_7F_7F( lcv );


		// xx - 7F - E4 - xx
		else if( CHECK2( 0x7F, 0xE4 ) )
			Clip16_7F_E4( lcv );


		// xx - 7F - FD - xx
		else if( CHECK2( 0x7F, 0xFD ) )
			Clip16_7F_FD( lcv );


		// ###############################################
		// ###############################################
		// ###############################################

		// xx - 8C - F1 - xx
		else if( CHECK2( 0x8C, 0xF1 ) )
			Clip16_8C_F1( lcv );


		// xx - E9 - F5 - xx
		else if( CHECK2( 0xE9, 0xF5 ) )
			Clip16_E9_F5( lcv );


		// xx - FF - [00-78] - xx
		else if( CHECK2_RANGE( 0xFF, 0x00, 0x78 ) )
			Clip16_FF__00_78( lcv );


		// xx - FF - 7E - xx
		else if( CHECK2( 0xFF, 0x7E ) )
			Clip16_FF_7E( lcv );


		// xx - FF - FB - xx
		else if( CHECK2( 0xFF, 0xFB ) )
			Clip16_FF_FB( lcv );


		// xx - FF - FD - xx
		else if( CHECK2( 0xFF, 0xFD ) )
			Clip16_FF_FD( lcv );


		// xx - FF - FE - xx
		else if( CHECK2( 0xFF, 0xFE ) )
			Clip16_FF_FE( lcv );


		// xx - FF - FF - xx
		else if( CHECK2( 0xFF, 0xFF ) )
			Clip16_FF_FF( lcv );
		*/
	}


	// unknown - don't adjust
	else if( dpcm_count >= 6 )
		clip_error = TRUE;



	if( clip_error == TRUE )
	{
		fprintf( fp_log, "--- Unknown pattern\n" );


		fix_clip = FALSE;
		error_found++;


		dpcm_count = 0;
	}


	if( clip_error2 == TRUE )
	{
		fprintf( fp_log, "--- Bad curve = %04X\n",
			( pcm[lcv-6] + Lookup8( buf[lcv-5] ) + Lookup8( buf[lcv-4] ) + Lookup8( buf[lcv-3] ) + Lookup8( buf[lcv-2] ) + Lookup8( buf[lcv-1] ) + Lookup8( buf[lcv-0] ) ) & 0xFFFF
		);


		fix_clip = FALSE;
		error_found++;


		dpcm_count = 0;
	}
}
